package org.checkerframework.checker.integrity;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.Tree.Kind;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.AssignmentTree;

import javax.lang.model.element.AnnotationMirror;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedDeclaredType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedPrimitiveType;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.checker.integrity.qual.Trusted;
import org.checkerframework.checker.integrity.qual.UnTrusted;


/**
 * A type-checking visitor for the Regex type system.
 *
 * <p>This visitor does the following:
 *
 * <ol>
 *   <li value="1">Allows any String to be passed to Pattern.compile if the Pattern.LITERAL flag is
 *       passed.
 *   <li value="2">Checks compound String concatenation to ensure correct usage of Regex Strings.
 *   <li value="3">Checks calls to {@code MatchResult.start}, {@code MatchResult.end} and {@code
 *       MatchResult.group} to ensure that a valid group number is passed.
 * </ol>
 *
 * @see RegexChecker
 */
public class IntegrityVisitor extends BaseTypeVisitor<BaseAnnotatedTypeFactory> {

private static final String HI_CONDITION = "tainted.condition";
protected final AnnotationMirror TAINTED;
protected final AnnotationMirror UNTAINTED; /* Bottom */
private static AnnotationMirror PC;


    public IntegrityVisitor(BaseTypeChecker checker) {
        super(checker);
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        TAINTED = AnnotationBuilder.fromClass(elements, UnTrusted.class);
        UNTAINTED = AnnotationBuilder.fromClass(elements, Trusted.class);
	PC = UNTAINTED;

    }

    /**
     * Case 1: Don't require a Regex annotation on the String argument to Pattern.compile if the
     * Pattern.LITERAL flag is passed.
     */
    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        return super.visitMethodInvocation(node, p);
    }

    private AnnotationMirror checkForHiValue(ExpressionTree tree, String errMsg) {
        AnnotatedTypeMirror type = atypeFactory.getAnnotatedType(tree);
        return checkForHiType(type, tree, errMsg);
    }

    private AnnotationMirror checkForHiType(
            AnnotatedTypeMirror type, Tree tree, String errMsg) {
        if (type.hasEffectiveAnnotation(TAINTED)) {
            return TAINTED;
        }
        return UNTAINTED;
    }


    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        checkForHiValue(node.getCondition(), HI_CONDITION);
        return super.visitConditionalExpression(node, p);
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        AnnotationMirror varlev = checkForHiValue(node.getVariable(),HI_CONDITION);
	if((PC == TAINTED) && (varlev == UNTAINTED)) 
        checker.report(Result.failure("implicit integrity leak in assignment",node),node);

        return super.visitAssignment(node, p);
    }



    @Override
    public Void visitIf(IfTree node, Void p) {
	AnnotationMirror save = PC;    
        PC = checkForHiValue(node.getCondition(), HI_CONDITION);
        node.getThenStatement().accept(this, p);
        final Tree elseStat = node.getElseStatement();
        if (elseStat != null) {
            elseStat.accept(this, p);
        }
        PC = save;
        return p;
    }

}
