package org.checkerframework.checker.secrecy;

import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedArrayType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedDeclaredType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedExecutableType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedIntersectionType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedPrimitiveType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedTypeVariable;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedUnionType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedWildcardType;
import org.checkerframework.framework.type.DefaultAnnotatedTypeFormatter;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.StructuralEqualityComparer;
import org.checkerframework.framework.type.SubtypeVisitHistory;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy.MultiGraphFactory;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

import org.checkerframework.checker.secrecy.qual.Secret;
import org.checkerframework.checker.secrecy.qual.ESecret;
import org.checkerframework.checker.secrecy.qual.Public;


import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;

import static org.checkerframework.framework.qual.TypeUseLocation.EXCEPTION_PARAMETER;
import static org.checkerframework.framework.qual.TypeUseLocation.FIELD;
import static org.checkerframework.framework.qual.TypeUseLocation.LOCAL_VARIABLE;
import static org.checkerframework.framework.qual.TypeUseLocation.LOWER_BOUND;
import static org.checkerframework.framework.qual.TypeUseLocation.OTHERWISE;
import static org.checkerframework.framework.qual.TypeUseLocation.PARAMETER;
import static org.checkerframework.framework.qual.TypeUseLocation.RECEIVER;
import static org.checkerframework.framework.qual.TypeUseLocation.RESOURCE_VARIABLE;
import static org.checkerframework.framework.qual.TypeUseLocation.RETURN;
import static org.checkerframework.framework.qual.TypeUseLocation.UPPER_BOUND;

public class SecrecyAnnotatedTypeFactory extends BaseAnnotatedTypeFactory {

    protected final AnnotationMirror SECRET;
    protected final AnnotationMirror PUBLIC;

    // FlowVisitor uses these to hold flow state

    //Qualifier defaults for byte code and poly flow defaulting

    public SecrecyAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);

        PUBLIC = AnnotationBuilder.fromClass(elements, Public.class);
        SECRET = AnnotationBuilder.fromClass(elements, Secret.class);

     // Every subclass must call postInit!
        if (this.getClass().equals(SecrecyAnnotatedTypeFactory.class)) {
            this.postInit();
        }
    }

    @Override
    protected void postInit() {
        super.postInit();
    }

    protected class FlowPolicyTreeAnnotator extends TreeAnnotator {

        public FlowPolicyTreeAnnotator(SecrecyAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

   }

   protected class FlowPolicyTypeAnnotator extends TypeAnnotator {

        // FlowChecker checker;
        public FlowPolicyTypeAnnotator(SecrecyAnnotatedTypeFactory factory) {
            super(factory);
        }

    }

    @Override
    protected MultiGraphQualifierHierarchy.MultiGraphFactory createQualifierHierarchyFactory() {
        return new MultiGraphQualifierHierarchy.MultiGraphFactory(this);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphFactory factory) {
        return new FlowQualifierHierarchy(factory);
    }

    @Override
    protected TypeHierarchy createTypeHierarchy() {
        return new FlowTypeHierarchy(checker, getQualifierHierarchy(),
                                     checker.getOption("ignoreRawTypeArguments","true").equals("true"),
                                     checker.hasOption("invariantArrays"));
    }


    class NormalizingStructuralEqualityComparer extends StructuralEqualityComparer {

        public NormalizingStructuralEqualityComparer(
                SubtypeVisitHistory typeargVisitHistory) {
            super(typeargVisitHistory);
        }

    }

    protected class FlowTypeHierarchy extends DefaultTypeHierarchy {

        public FlowTypeHierarchy(BaseTypeChecker checker,
                QualifierHierarchy qualifierHierarchy, boolean ignoreRawTypes, boolean invariantArrays) {
            super(checker, qualifierHierarchy, ignoreRawTypes, invariantArrays);
        }

        @Override
        public StructuralEqualityComparer createEqualityComparer() {
            return new NormalizingStructuralEqualityComparer(typeargVisitHistory);
        }
    }


    protected class FlowQualifierHierarchy extends MultiGraphQualifierHierarchy {

        protected FlowQualifierHierarchy(MultiGraphFactory f) {
            super(f);
        }

        @Override
        protected Set<AnnotationMirror> findBottoms(
                Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newbottoms = AnnotationUtils.createAnnotationSet();

            return newbottoms;
        }

        @Override
        protected Set<AnnotationMirror> findTops(
                Map<AnnotationMirror, Set<AnnotationMirror>> supertypes) {
            Set<AnnotationMirror> newtops = AnnotationUtils.createAnnotationSet();

            return newtops;
        }


        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return SECRET;

        }

        @Override
        public AnnotationMirror getBottomAnnotation(AnnotationMirror start) {
            return PUBLIC;

        }

        @Override
        public boolean isSubtype(AnnotationMirror subtype, AnnotationMirror supertype){
            if (AnnotationUtils.areSameByClass(subtype,Public.class))
            {
		String arg = getSource(subtype);
                System.out.println(arg);
                return true;
            }
            if (AnnotationUtils.areSameByClass(supertype,Public.class)) return true;
            return false;
            /*return super.isSubtype(subtype,supertype); */
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {

            if (isSubtype(a1, a2))
                return a2;
            if (isSubtype(a2, a1))
                return a1;

            return super.leastUpperBound(a1, a2);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {

            if (AnnotationUtils.areSame(a1, a2))
                return a1;

            return super.greatestLowerBound(a1, a2);
        }

   

    }


      private static String getSource(final AnnotationMirror am) {

        String source = AnnotationUtils.getElementValue(am,
                "value", String.class, true);
        return source;
         }
}
