package org.checkerframework.checker.secrecy;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.Tree.Kind;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.AnnotationTree;

import java.util.List;

import javax.lang.model.element.Element;
import javax.lang.model.element.AnnotationMirror;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedDeclaredType;
import org.checkerframework.framework.type.AnnotatedTypeMirror.AnnotatedPrimitiveType;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.checker.secrecy.qual.Secret;
import org.checkerframework.checker.secrecy.qual.ESecret;
import org.checkerframework.checker.secrecy.qual.Public;

import org.checkerframework.checker.secrecy.SecrecyAnnotatedTypeFactory;

/**
 * A type-checking visitor for the Regex type system.
 *
 * <p>This visitor does the following:
 *
 * <ol>
 *   <li value="1">Allows any String to be passed to Pattern.compile if the Pattern.LITERAL flag is
 *       passed.
 *   <li value="2">Checks compound String concatenation to ensure correct usage of Regex Strings.
 *   <li value="3">Checks calls to {@code MatchResult.start}, {@code MatchResult.end} and {@code
 *       MatchResult.group} to ensure that a valid group number is passed.
 * </ol>
 *
 * @see RegexChecker
 */
public class SecrecyVisitor extends BaseTypeVisitor<SecrecyAnnotatedTypeFactory> {

private static final String HI_CONDITION = "hi.condition";
protected final AnnotationMirror SECRET;
protected final AnnotationMirror PUBLIC;
protected final AnnotationMirror ESECRET;
private AnnotationMirror PC;


    public SecrecyVisitor(BaseTypeChecker checker) {
        super(checker);
        SECRET = AnnotationBuilder.fromClass(elements, Secret.class);
        PUBLIC = AnnotationBuilder.fromClass(elements, Public.class);
        ESECRET = AnnotationBuilder.fromClass(elements, ESecret.class);
	PC = PUBLIC;

    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
      AnnotationMirror save = PC;
      if (hasESecret(node)) {
          PC = SECRET;
      }
      Void pr = super.visitMethod(node, p);
      PC = save;
      return pr;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        ExecutableElement methodElement = TreeUtils.elementFromUse(node);
        AnnotationMirror pureAnnotation =
          atypeFactory.getDeclAnnotation(methodElement,ESecret.class);
        if((pureAnnotation==null /* PUBLIC */) && (PC == SECRET))
          checker.report(Result.failure("Possible Secrecy leak in method call",node),node);
        return super.visitMethodInvocation(node, p);
    }

        private AnnotationMirror checkForHiValue(ExpressionTree tree, String errMsg) {
        AnnotatedTypeMirror type = atypeFactory.getAnnotatedType(tree);
        return checkForHiType(type, tree, errMsg);
    }

    private AnnotationMirror checkForHiType(
            AnnotatedTypeMirror type, Tree tree, String errMsg) {
        if (type.hasEffectiveAnnotation(SECRET)) {
            return SECRET;
        }
        return PUBLIC;
    }


    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        checkForHiValue(node.getCondition(), HI_CONDITION);
        return super.visitConditionalExpression(node, p);
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        AnnotationMirror varlev = checkForHiValue(node.getVariable(),HI_CONDITION);
	if((PC == SECRET) && (varlev == PUBLIC)) 
        checker.report(Result.failure("implicit flow in assignment",node),node);

        return super.visitAssignment(node, p);
    }

    @Override
    public Void visitIf(IfTree node, Void p) {
	AnnotationMirror  pcbefore= PC;    
        PC = checkForHiValue(node.getCondition(), HI_CONDITION);
        node.getThenStatement().accept(this, p);
        final Tree elseStat = node.getElseStatement();
        if (elseStat != null) {
            elseStat.accept(this, p);
        }
        PC = pcbefore;
        return p;
    }
    

    public boolean hasESecret(MethodTree tree)
    {        
        Element methodElement = TreeUtils.elementFromTree(tree);
        AnnotationMirror pureAnnotation =
          atypeFactory.getDeclAnnotation(methodElement,ESecret.class);
        return (pureAnnotation != null);
    }

}
